/*
 * Decompiled with CFR 0.152.
 */
package net.customnpcskins;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.regex.Pattern;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="customnpcskins", name="CustomNPCSkins", version="2.0.0", acceptedMinecraftVersions="[1.12,1.13)", acceptableRemoteVersions="*")
public final class CustomNPCSkins {
    public static final String MODID = "customnpcskins";

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        File cfgDir = e.getModConfigurationDirectory();
        CustomNPCSkins.patchBool(new File(cfgDir, "forge.cfg"), "B:removeErroringEntities", "false");
        CustomNPCSkins.patchBool(new File(cfgDir, "forge.cfg"), "B:removeErroringTileEntities", "false");
    }

    private static void patchBool(File cfg, String key, String desired) {
        try {
            if (!cfg.exists()) {
                return;
            }
            String s = new String(Files.readAllBytes(cfg.toPath()), StandardCharsets.UTF_8);
            String replaced = s.replaceAll("(?m)^\\s*" + Pattern.quote(key) + "\\s*(true|false)\\s*$", key + "=" + desired);
            if (!replaced.equals(s)) {
                Files.write(cfg.toPath(), replaced.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                System.out.println("[CustomNPCSkins] Set " + key + "=" + desired + " in " + cfg.getName() + " (takes effect next run)");
            }
        }
        catch (Exception ex) {
            System.out.println("[CustomNPCSkins] Could not patch " + cfg + ": " + ex.getMessage());
        }
    }
}

